//
// (c) 2020 wesolutions GmbH
// All rights reserved.
//

import QtQuick 2.4

import wesual.Controls 1.0

VirtualKey {
    id : symbolKey

    property var keyboard

    property int digit : 0

    Text {
        id : digitText

        anchors {
            centerIn : parent
        }
        font {
            family    : "Lato"
            weight    : Font.Light
            pixelSize : 32
        }
        text  : parent.digit
        color : highlight ? "white" : "#5F5F5F"

        Behavior on color {
            ColorAnimation { duration : 70 }
        }
    }
    onClicked : keyboard.triggerKeyEvent(
                    Qt.Key_0 + symbolKey.digit, digit.toString())
}
